$dockerConfig = @"
{
  "log-driver": "json-file",
  "log-opts": {
    "max-size": "100m",
    "max-file": "3"
  }
}
"@

$dockerConfigPath = "C:\ProgramData\Docker\config\daemon.json"

if (!(Test-Path "C:\ProgramData\Docker\config")) {
    New-Item -ItemType Directory -Path "C:\ProgramData\Docker\config" -Force
}

$dockerConfig | Set-Content -Path $dockerConfigPath -Encoding UTF8 -Force

Restart-Service com.docker.service -Force

# VMS Installation Prompt
Write-Host "`nVMS AI modules will take additional 6-9 GB of free space."
Write-Host "Would you like to proceed?"
Write-Host "Press 'y' to install or any other button to skip.`n"

$answer = Read-Host "Enter your choice"

$compose_file = "./docker-confs/docker-compose-noai.yml"

if ($answer -match "^[Yy]") {
    $compose_file = "./docker-confs/docker-compose-ai.yml"
    Write-Host "AI modules will be installed"
} else {
    Write-Host "Skipping installation of AI modules"
}

Copy-Item -Path $compose_file -Destination "./docker-compose.yml" -Force

Write-Host "`nInstalling VMS...`n"

$scriptDirectory = $PSScriptRoot

$tzScript = Join-Path -Path $scriptDirectory -ChildPath 'newTZ.ps1'
$ipScript = Join-Path -Path $scriptDirectory -ChildPath 'newIP.ps1' 
$disksScript = Join-Path -Path $scriptDirectory -ChildPath 'newDisks.ps1' 
$startScript = Join-Path -Path $scriptDirectory -ChildPath 'start.ps1'

& $tzScript
& $ipScript
& $disksScript
& $startScript
