$routeTable = route print | Select-String "0.0.0.0" | ForEach-Object { $_.ToString().Split(" ", [System.StringSplitOptions]::RemoveEmptyEntries) }

$gateway = $routeTable[2]  # Gateway (used for SUBNET_ADDRESS)
$localIp = $routeTable[3]  # Interface IP (used for LOCAL_HOST, APP_HOST, MACHINE_HOST)

if (-not $gateway) {
    Write-Host "No valid gateway found."
    exit 1
}

if (-not $localIp) {
    Write-Host "No valid IPv4 address found."
    exit 1
}

$envFile = ".env"

Copy-Item -Path $envFile -Destination "$envFile.bak" -Force

$envContent = Get-Content -Path $envFile

$newContent = @()

foreach ($line in $envContent) {
    $key, $value = $line -split "=", 2 

    if ($key -eq "LOCAL_HOST" -or $key -eq "APP_HOST" -or $key -eq "MACHINE_HOST") {
        $value = $localIp
    }

    if ($key -eq "SUBNET_ADDRESS") {
        $value = $gateway
    }

    $newContent += "$key=$value"
}

Set-Content -Path $envFile -Value $newContent

#Write-Host "Updated .env file successfully!"
Remove-Item -Path "$envFile.bak" -Force
