# Get the timezone from WSL
$TZ = wsl cat /etc/timezone

if (-not $TZ) {
    Write-Host "Could not retrieve timezone from WSL."
    exit 1
}

$envFile = ".env"

Copy-Item -Path $envFile -Destination "$envFile.bak" -Force

$envContent = Get-Content -Path $envFile

$newContent = @()

foreach ($line in $envContent) {
    $key, $value = $line -split "="
    
    if ($key -eq "TZ") {
        $value = $TZ
    }

    $newContent += "$key=$value"
}

Set-Content -Path $envFile -Value $newContent
