# Get all logical drives (C:, D:, E:, etc.)
$drives = Get-WmiObject Win32_LogicalDisk | Where-Object { $_.DriveType -eq 3 } | Select-Object -ExpandProperty DeviceID


$composeFile = "docker-compose.yml"
$fileContent = Get-Content $composeFile -Raw

# Define the volumes to add in the required format (e.g., C:/mnt/C, D:/mnt/D)
$newVolumes = $drives | ForEach-Object { "- $_/:/mnt/$($_.TrimEnd(':'))" }


$fileLines = $fileContent -split "`r?`n"


$volumesIndex = -1
foreach ($index in 0..($fileLines.Length - 1)) {

    if ($fileLines[$index].Trim() -match '^\s*volumes:\s*$') {
        $volumesIndex = $index
        break
    }
}

if ($volumesIndex -gt -1) {

    $fileLines = $fileLines[0..$volumesIndex] + ($fileLines[($volumesIndex+1)..($fileLines.Length - 1)] | Where-Object { $_ -notmatch '^\s*- [A-Z]:/.*$' })


    $newVolumeLines = $newVolumes | ForEach-Object { "      $_" }


    $fileLines = $fileLines[0..$volumesIndex] + "      " + ($newVolumeLines -join "`r`n") + "`r`n" + $fileLines[($volumesIndex + 1)..($fileLines.Length - 1)]


    $fileLines = $fileLines | Where-Object { $_.Trim() -ne "" }


    $updatedFileContent = $fileLines -join "`r`n"


    Set-Content $composeFile -Value $updatedFileContent

    Write-Host "Volumes have been updated in docker-compose.yml."
} else {
    Write-Host "'volumes:' section not found in docker-compose.yml"
}
