#!/bin/sh

set -o errexit
set -o nounset

IFS=$(printf '\n\t')

# Docker installation
# sudo apt remove --yes docker docker-engine docker.io containerd runc || true
sudo apt update
sudo apt --yes --no-install-recommends install apt-transport-https ca-certificates curl
wget --quiet --output-document=- https://download.docker.com/linux/ubuntu/gpg | sudo apt-key add -
sudo add-apt-repository --yes "deb [arch=$(dpkg --print-architecture)] https://download.docker.com/linux/ubuntu $(lsb_release --codename --short) stable"
sudo apt update
sudo apt --yes --no-install-recommends install docker-ce docker-ce-cli containerd.io
sudo usermod --append --groups docker "$USER"
sudo systemctl enable docker
printf '\nDocker installed successfully\n\n'

printf 'Waiting for Docker to start...\n\n'
sleep 5

DOCKER_DAEMON_CONFIG='{
  "log-driver": "json-file",
  "log-opts": {
    "max-size": "100m",
    "max-file": "3"
  }
}'

echo "$DOCKER_DAEMON_CONFIG" | sudo tee /etc/docker/daemon.json
sudo systemctl restart docker

# Docker-Compose installation
sudo curl -L "https://github.com/docker/compose/releases/download/$(curl -s https://api.github.com/repos/docker/compose/releases/latest | grep '\"tag_name\":' | sed -E 's/.*\"([^\"]+)\".*/\1/')/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose

sudo chmod +x /usr/local/bin/docker-compose
printf '\nDocker-Compose installed successfully\n\n'
sleep 2

# VMS installation
echo "
VMS analytics module will take 9 GB of free space.
Would you like to proceed?
Press 'y' to install or any other button to skip.
"

read answer

compose_file="./docker-confs/docker-compose-noai.yml"

sudo chmod +x ./lpr-scripts/install-lpr-lic.sh
sudo chmod +x ./lpr-scripts/uninstall-lpr-lic.sh

case "${answer}" in
[Yy]* )
    compose_file="./docker-confs/docker-compose-ai.yml"
    echo "AI modules will be installed"
    sudo bash ./lpr-scripts/install-lpr-lic.sh
    ;;
*)
    echo "Skipping AI module installation"
    ;;
esac

cp "${compose_file}" ./docker-compose.yml

printf '\nInstalling VMS\n\n'
ip_address=`hostname -I | awk '{ print $1 }'`
sed -i "/^MACHINE_HOST=/s/[^=]*$/${ip_address}/;/^APP_HOST=/s/[^=]*$/${ip_address}/" .env

TRIAL_TIME=$(date -d "+2 weeks" +%s)
printf "\nLPR_TRIAL_TIME=%s\n" "$TRIAL_TIME" >> .env

sudo chmod 644 ./confs/mysql-conf/*

# Scripts enablement
sudo chmod +x uninstall.sh
sudo chmod +x new-ip.sh
sudo chmod +x start.sh
sudo chmod +x stop.sh
sudo chmod +x update.sh
sudo chmod +x restart.sh
sudo chmod +x update-conf-path.sh

sh update-conf-path.sh
docker-compose pull 2>&1 | grep -v "variable"

DATABASE_CONTAINER="vms-db"
MIGRATION_CONTAINER="vms-migration"

wait_for_service() {
     while true; do
        if docker logs $1 --tail 100 2>&1 | grep -q "$2"; then
            echo "$3"
            break
        fi
        sleep 5
    done
}

docker-compose up -d $DATABASE_CONTAINER 2>&1 | grep -v "variable"
printf '\nWaiting for database initialization...\n'
wait_for_service $DATABASE_CONTAINER "ready for connections" "DB is ready for connections."

printf '\nRunning migration...\n'
docker-compose up -d $MIGRATION_CONTAINER 2>&1 | grep -v "variable"
wait_for_service $MIGRATION_CONTAINER "migration success" "Migration succeeded."

printf '\nStarting services...\n'
docker-compose up -d 2>&1 | grep -v "variable"
