#!/bin/bash
set -e


GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[0;33m'
NC='\033[0m' # No Color

echo -e "${GREEN}Removing License Service...${NC}"

if [ "$EUID" -ne 0 ]; then
  echo -e "${RED}Please run as root (sudo)${NC}"
  exit 1
fi

INSTALL_DIR="/opt/license-service"
SYSTEMD_DIR="/etc/systemd/system"
SERVICE_FILE="$SYSTEMD_DIR/license-service.service"

if [ ! -f "$SERVICE_FILE" ]; then
  echo -e "${YELLOW}License Service is not found in system.${NC}"
  
  if [ -d "$INSTALL_DIR" ]; then
    echo -e "${YELLOW}Found installation folder. Removing...${NC}"
  else
    echo -e "${RED}Installation folder is not found. Skipping.${NC}"
    exit 1
  fi
else
  echo "Stopping License Service..."
  systemctl stop license-service.service || true
  
  echo "Disabling..."
  systemctl disable license-service.service || true
  
  echo "Removing service file..."
  rm -f "$SERVICE_FILE"
  
  echo "Restarting systemd..."
  systemctl daemon-reload
  systemctl reset-failed || true
fi

echo "Removing License Service files..."
rm -rf "$INSTALL_DIR"

if id "license-service" &>/dev/null; then
  echo "Deleting license-service user..."
  userdel license-service || true
fi

if [ ! -d "$INSTALL_DIR" ] && [ ! -f "$SERVICE_FILE" ]; then
  echo -e "${GREEN}License Service is uninstalled!${NC}"
else
  echo -e "${RED}Error occured during uninstallation process.Please check the system manually.${NC}"
  
  if [ -d "$INSTALL_DIR" ]; then
    echo -e "${YELLOW}$INSTALL_DIR directory still exists.${NC}"
  fi
  
  if [ -f "$SERVICE_FILE" ]; then
    echo -e "${YELLOW}$SERVICE_FILE file still exists.${NC}"
  fi
  
  exit 1
fi

if command -v journalctl &>/dev/null; then
  echo "Cleaning up License Service journals..."
  journalctl --vacuum-time=1s --identifier=license-service || true
fi

echo -e "${GREEN}Finished!${NC}"
